C***********************************************************************
C PROGRAM   ( C P 1 2 ) 	 ALIAS	 ( P P P )
C
C CREATED:  ??/??/??   A.B.C.
C MODIFIED: ??/??/??   A.B.C   -ITEMS CHANGED AND REASON
C MODIFIED: 08/17/87   A.J.S   -CHANGES SO CAN BE COMPILED WITH
C				MS/FORTRAN UNDER VERSION 4.0.
C***********************************************************************
C
       PROGRAM CP12
C
       COMMON /BL1/BETA(30,30)
     &	      /BL2/GAMMA(30,30)
     &	      /BL3/C(30,30)
     &	      /BL4/P(30,30)
     &	      /BL5/Q(30,30)
     &	      /BL6/PC(30,30)
     &	      /BL11/AI(30),E(30),NZ(30)
     &	      /BL12/CX(30),CY(30),CZ(30)
     &	      /BL13/EIG(30)
     &	      /BL14/ADGAN(30)
     &	      /BL15/QX(30),QY(30),QZ(30)
     &	      /BL16/EC1(30),EC2(30),EC3(30)
C
       OPEN(UNIT=1,FILE='CP3.DAT',STATUS='UNKNOWN')
       OPEN(UNIT=2,FILE='CP3.RES',STATUS='UNKNOWN')
C
       CALL RDATA(N,NF,NIT,NCI,NU,NL,NPM,CONV,AAL)
       CALL WDATA(N,NF,NIT,NCI,NU,NL,CONV)
       CALL ADBETA(AAL)
       CLOSE (UNIT=1)
       CALL HUCKEL(N,NF)
       CALL SCF(N,NF,NIT,CONV)
       CALL WOUT(N)
       CALL PRESVE(N)
       CALL TOTEN(N)
       CALL SGTP(N,NF,NPM,NCI,NU,NL,IST,JST,ISE,JSE)
       CALL DENSTY(IST,JST,ISE,JSE,N,NF)
       CALL DIPOLE(N,0)
       CALL DIPOLE(N,1)
       CALL DIPOLE(N,2)
       CLOSE (UNIT=2)
       STOP
       END
C
C***********************************************************************
C
       SUBROUTINE RDATA(N,NF,NIT,NCI,NU,NL,NPM,CONV,AAL)
       COMMON /BL1/BETA(30,30)
     &	      /BL2/GAMMA(30,30)
     &	      /BL11/AI(30),E(30),NZ(30)
     &	      /BL12/CX(30),CY(30),CZ(30)
     &	      /BL14/ADGAN(30)
C
       READ(1,*) N,NCA,NCB,NPM,NCI
       IF((NCI.EQ.1).OR.(NCI.EQ.0)) GOTO 5
       READ(1,*) NU,NL
       GOTO 10
   5   NU=N
       NL=1
  10   IF(NCA.EQ.2) GOTO 15
       READ(1,*) NF
       GOTO 20
  15   NF=N/2
  20   IF(NCA.NE.3) GOTO 25
       READ(1,*) NIT,CONV
  25   NIT=15
       CONV=0.001
  30   IF(NCA.EQ.2) GOTO 35
       READ(1,*) (AI(I),I=1,N)
       READ(1,*) (E(I),I=1,N)
       READ(1,*) (NZ(I),I=1,N)
       GO TO 40
  35   READ(1,*) X
       READ(1,*) Y
       DO 36 I=1,N
	 AI(I)=X
	 E(I)=Y
	 NZ(I)=1
  36   CONTINUE
  40   WRITE(6,101) N,NCA,NCB,NPM,NCI,NU,NL,NF
  101  FORMAT(8I5)
       WRITE(6,102) (AI(I),E(I),NZ(I),I=1,N)
  102  FORMAT (2F10.2,I5)
       CALL RBETA(N)
       WRITE(6,103) ((BETA(I,J),J=1,N),I=1,N)
  103  FORMAT(6F10.2)
       IF(ICCB-2) 45,50,55
  45   CALL SHAPE (N,NPM,AAL)
       GOTO 100
  50   CALL MATRIX(N)
       CALL COORDS(N,NPM)
  55   IF(NPM.EQ.1) GOTO 60
       DO 56 I=1,N
	 CX(I)=0.0
  56   CONTINUE
       GOTO 70
  60   READ(1,*) (CX(I),I=1,N)
  70   READ(1,*) (CY(I),I=1,N)
       READ(1,*) (CZ(I),I=1,N)
       DO 75 I=1,N
	 GAMMA(I,I)=0.0
	 K=I+1
	 DO 75 J=K,N
	   IF(IPM.EQ.0) GOTO 72
	   X=CX(I)-CX(J)
	   GOTO 74
  72	   X=0.0
  74	   Y=CY(I)-CY(J)
	   Z1=CZ(I)-CZ(J)
  75   CONTINUE
  100  RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE WDATA(N,NF,NIT,NCI,NU,NL,CONV)
       COMMON /BL1/BETA(30,30)
     &	      /BL2/GAMMA(30,30)
     &	      /BL11/AI(30),E(30),NZ(30)
     &	      /BL12/CX(30),CY(30),CZ(30)
C
       WRITE(2,999) N
 999   FORMAT(' NUMBER OF CENTERS = ',I5,/)
       WRITE(2,998) NF
 998   FORMAT(' NUMBER OF DOUBLY OCCUPIED SHELLS =',I5,/)
       IF(NCI.EQ.0) GOTO 10
       WRITE(2,997) NU
 997   FORMAT(' UPPER LIMIT OF CI =', I5,/)
       WRITE(2,996) NL
 996   FORMAT(' LOWER LIMIT OF CI =', I5,/)
  10   WRITE(2,995) NIT
 995   FORMAT(' MAX NUMBER OF SCF ITERATIONS =',I5,/)
       WRITE(2,994) CONV
 994   FORMAT(' CONVERGENCE CRITERION =',F10.4,/)
       WRITE(2,993)
 993   FORMAT(' RESONANCE INTEGRAL MATRIX =',/)
       DO 15 I=1,N
	 WRITE(2,992) (BETA(I,J),J=1,N)
 15    CONTINUE
 992   FORMAT(10F10.4)
       WRITE(2,991)
 991   FORMAT(/,' INTER-ATOMIC DISTANCE MATRIX) ',/)
       DO 20 I=1,N
	 WRITE(2,992) (GAMMA(I,J),J=1,N)
 20    CONTINUE
       WRITE(2,990)
 990   FORMAT(/,' ATOMIC COORDINATES',//,' X-COORDS',/)
       WRITE(2,992) (CX(I),I=1,N)
       WRITE(2,989)
 989   FORMAT(/,' Y-COORDS',/)
       WRITE(2,992) (CY(I),I=1,N)
       WRITE(2,988)
 988   FORMAT(/,' Z-COORDS',/)
       WRITE(2,992) (CZ(I),I=1,N)
       WRITE(2,987)
 987   FORMAT(/,' ATOMIC IONIZATION POTENTIALS',/)
       WRITE(2,992) (AI(I), I=1,N)
       WRITE(2,986)
 986   FORMAT(/,' ATOMIC ELECTRON AFFINITIES',/)
       WRITE(2,992) (E(I),I=1,N)
       WRITE(2,985)
 985   FORMAT(/,' ATOMIC VIRTUAL',/)
       WRITE(2,984) (NZ(I),I=1,N)
 984   FORMAT(10I10)
       RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE COORDS(N,NPM)
       COMMON /BL2/GAMMA(30,30)
     &	      /BL12/CX(30),CY(30),CZ(30)
C
       CX(1)=0.0
       CY(1)=0.0
       CZ(1)=0.0
       CX(2)=0.0
       CY(2)=0.0
       CZ(2)=GAMMA(1,2)
       IF(N.EQ.2) GOTO 100
       CX(3)=0.0
       A=GAMMA(1,3)
       A=A*A
       B=GAMMA(2,3)
       B=B*B
       C=CZ(2)
       C=C*C
       B=(A-B+C)/CZ(2)*0.5
       CZ(3)=B
       B=B*B
       B=A-B
       CY(3)=SQRT(B)
       IF (N.EQ.3) GOTO 100
       DO 20 I=4,N
	 A=GAMMA(1,I)
	 A=A*A
	 D=GAMMA(2,I)
	 D=D*D
	 CZ(I)=(A-D+C)/CZ(2)*0.5
	 A=A*A
	 D=CZ(3)-CZ(I)
	 D=D*D
	 A=D-A
	 D=GAMMA(3,I)
	 D=D*D
	 A=A-D
	 D=GAMMA(2,I)
	 D=D*D
	 A=A+D
	 CY(I)=(A+B)/CY(3)*0.5
  20   CONTINUE
       IF(NPM.EQ.0) GOTO 40
       DO 30 I=4,N
	 CX(I)=0.0
  30   CONTINUE
       GOTO 100
  40   CMAX=0.0
       DO 50 I=4,N
	 A=GAMMA(1,I)
	 A=A*A
	 B=CZ(I)
	 B=B*B
	 C=CY(I)
	 C=C*C
	 D=A-B-C
	 IF(D.GE.0.0) GOTO 45
	 D=-D
	 D=-1.0*D
	 WRITE(2,999)
 999	 FORMAT(' INACCURATE GEOMETRY')
  45	 CX(I)=SQRT(D)
	 IF(CZ(I).LE.CMAX) GOTO 50
	 CMAX=CX(I)
	 J=I
  50   CONTINUE
       IF(N.EQ.4) GOTO 100
       DO 60 I=4,N
	 IF(I.EQ.J) GOTO 60
	 B=CY(J)-CY(I)
	 B=B*B
	 C=CZ(J)-CZ(I)
	 C=C*C
	 D=GAMMA(I,J)
	 D=D*D
	 D=D-B-C
	 A=D-A*A
	 A=A*A
	 B=CX(J)-CX(I)
	 B=D-B*B
	 IF(A.LE.B) GOTO 60
  60   CONTINUE
 100   RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE RBETA(N)
       COMMON /BL1/BETA(30,30)
C
       DO 10 I=1,N
	 DO 10 J=1,N
	   BETA(I,J)=0.0
  10   CONTINUE
  20   READ(1,*) I,J,B
       IF(I.EQ.0) GOTO 100
       BETA(I,J)=B
       BETA(J,I)=B
       GOTO 20
 100   RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE MATRIX(N)
       COMMON /BL2/GAMMA(30,30)
C
       A=0.0
       READ(1,*) B
       DO 10 I=1,N
	 K=I+1
	 GAMMA(I,I)=A
	 DO 10 J=K,N
	   GAMMA(I,J)=B
	   GAMMA(J,I)=B
  10   CONTINUE
       RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE SHAPE(N,NPM,AAL)
       COMMON /BL2/GAMMA(30,30)
     &	      /BL12/CX(30),CY(30),CZ(30)
     &	      /BL14/ADGAN(30)
C
       DIMENSION ANG(30)
       DO 10 I=1,N
	 CX(I)=0.0
	 DO 10 J=1,N
	   GAMMA(I,J)=0.0
   10  CONTINUE
       ADGAN(1)=1.0
       CZ(1)=0.0
       CY(1)=0.0
       ANG(1)=0.0
   15  IF(NPM.NE.0) GOTO 16
       READ(1,*) I,J,R1,ALPHA
       GOTO 18
   16  READ(1,*) I,J,R1,ALPHA,AL1
   18  IF(I.EQ.0) GOTO 50
       GAMMA(I,J)=R1
       GAMMA(J,I)=R1
       ALPHA=ALPHA+ANG(I)
       WRITE(6,104) I,J,GAMMA(I,J),ALPHA
  104  FORMAT(2I5,2F10.2)
       IF(ALPHA.LT.360.) GOTO 20
       ALPHA=ALPHA-360.
   20  ANG(J)=ALPHA
       ALPHA=ALPHA*0.01745327
       CY(J)=CY(I)+R1*SIN(ALPHA)
       CZ(J)=CZ(I)+R1*COS(ALPHA)
       IF(NPM.EQ.0) GOTO 15
       IF(AL1.EQ.0) GOTO 25
       ADGAN(I)=-J
       AAL=AL1
       AL1=AL1*0.01745327
       CX(J)=CY(J)*SIN(AL1)
       CY(J)=CY(J)**COS(AL1)
       GOTO 15
   25  ADGAN(J)=J
       GOTO 15
   50  L=N-1
       WRITE(6,105)I
  105  FORMAT(I5)
       DO 60 I=1,L
	 K=I+1
	 DO 60 J=K,N
	   IF(GAMMA(I,J).GT.0.001) GOTO 60
	   R1=CZ(J)-CZ(I)
	   R1=R1*R1
	   ALPHA=CY(J)-CY(I)
	   ALPHA=ALPHA*ALPHA
	   GAMMA(I,J)=SQRT(ALPHA+R1)
	   GAMMA(J,I)=GAMMA(I,J)
   60  CONTINUE
       RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE SCF(N,NF,NIT,CONV)
       COMMON /BL1/BETA(30,30)
     &	      /BL2/GAMMA(30,30)
     &	      /BL3/C(30,30)
     &	      /BL4/P(30,30)
     &	      /BL5/Q(30,30)
     &	      /BL11/AI(30),E(30),NZ(30)
     &	      /BL13/EIG(30)
C
       CALL MGA(N)
       WRITE(6,990) ((GAMMA(I,J),J=1,N),I=1,N)
  990  FORMAT(6F10.4)
       DO 10 I=1,N
	 DO 10 J=I,N
	   BETA(J,I)=P(I,J)
   10  CONTINUE
       DO 100 K=1,NIT
	 DO 40 I=1,N
	   I1=I+1
	   AJEN=0.0
	   DO 30 L=1,N
	     AJEN=AJEN+(P(L,L)-NZ(L)*1.0)*GAMMA(I,L)
   30	   CONTINUE
	   C(I,I)=AJEN+(-AI(I)-GAMMA(I,I)*(0.5*P(I,I)-1.0*NZ(I)))
	   DO 40 J=I1,N
	     C(I,J)=BETA(I,J)-0.5*P(I,J)*GAMMA(I,J)
	     C(J,I)=C(I,J)
   40	 CONTINUE
	 CALL EIGN(N)
	 CALL BONDER(2,N,NF)
	 DO 60 I=1,N
	   DO 60 J=I,N
	     CC=ABS(BETA(J,I)-Q(I,J))
	     IF(CC.GT.CONV) GOTO 55
   60	 CONTINUE
	 GOTO 150
   55	 CONTINUE
	 DO 50 M=1,N
	   DO 50 L=M,N
	     BETA(L,M)=Q(M,L)
	     P(M,L)=Q(M,L)
	     P(L,M)=P(M,L)
   50	 CONTINUE
  100  CONTINUE
       WRITE(2,999) NIT
  999  FORMAT(/,' NUMBER OF ITERATIONS=',I5)
       WRITE(2,998)
  998  FORMAT(/,' BOND MATRIX NOT CONVERGED TO REQUIRED EXTENT')
       GOTO 200
  150  CONTINUE
       DO 140 I=1,N
	 DO 140 J=I,N
	   BETA(J,I)=Q(I,J)
	   P(I,J)=Q(I,J)
	   P(J,I)=P(I,J)
  140  CONTINUE
       WRITE(2,999) K
       WRITE(2,997)
  997  FORMAT(/,' BOND MATRIX CONVERGED TO REQUIRED EXTENT')
  200  RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE TOTEN(N)
       COMMON /BL1/BETA(30,30)
     &	      /BL2/GAMMA(30,30)
     &	      /BL3/C(30,30)
     &	      /BL5/Q(30,30)
     &	      /BL11/AI(30),E(30),NZ(30)
C
       DO 10 I=1,N
	 BETA(I,I)=0.0
	 K=I+1
	 DO 10 J=K,N
	   BETA(J,I)=BETA(I,J)
  10   CONTINUE
       DO 50 I=1,N
	 I1=I+1
	 AJEN=0.0
	 DO 40 L=1,N
	   AJEN=AJEN+(Q(L,L)-NZ(L))*GAMMA(I,L)
  40	 CONTINUE
	 C(I,I)=-AI(I)-GAMMA(I,I)*(0.5*Q(I,I)-NZ(I))+AJEN
	 DO 50 J=I1,N
	 C(I,J)=BETA(I,J)-0.5*Q(I,J)*GAMMA(I,J)
	 C(J,I)=C(I,J)
  50   CONTINUE
       AJEN1=0.0
       DO 100 I=1,N
	 AJEN2=0.0
	 AJEN3=0.0
	 DO 80 J=1,N
	   AJEN2=AJEN2+Q(I,J)*(BETA(I,J)+C(I,J))
	   AJEN3=AJEN3+NZ(J)*GAMMA(I,J)
  80	 CONTINUE
	 AJEN1=AJEN1+AJEN2+Q(I,I)*(-BETA(I,I)-AI(I)+NZ(I)
     &	   *GAMMA(I,I)-AJEN3)
  100  CONTINUE
       EN=0.5*AJEN1
       WRITE(2,999) EN
  999  FORMAT(//,' TOTAL ENERGY=',F15.4)
       RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE BONDER(IS,N,NF)
       COMMON /BL3/C(30,30)
     &	      /BL4/P(30,30)
     &	      /BL5/Q(30,30)
C
       DO 20 I=1,N
	 DO 20 J=1,N
	   IF(IS.EQ.1) P(I,J)=0.0
	   IF(IS.EQ.2) Q(I,J)=0.0
	   DO 10 K=1,NF
	     IF(IS.EQ.1) P(I,J)=P(I,J)+2*C(K,I)*C(K,J)
	     IF(IS.EQ.2) Q(I,J)=Q(I,J)+2*C(K,I)*C(K,J)
  10	   CONTINUE
	   IF(IS.EQ.1) P(J,I)=P(I,J)
	   IF(IS.EQ.2) Q(J,I)=Q(I,J)
   20  CONTINUE
       RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE HUCKEL (N,NF)
       COMMON /BL1/BETA(30,30)
     &	      /BL3/C(30,30)
     &	      /BL4/P(30,30)
     &	      /BL13/EIG(30)
C
       DO 20 I=1,N
	 DO 20 J=I,N
	   C(I,J)=BETA(I,J)
	   C(J,I)=C(I,J)
  20   CONTINUE
       CALL EIGN(N)
       CALL BONDER(1,N,NF)
       WRITE(2,999)
  999  FORMAT(/,' HUCKEL APPROXIMATION')
       CALL WOUT(N)
       RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE WOUT(N)
       COMMON /BL3/C(30,30)
     &	      /BL4/P(30,30)
     &	      /BL13/EIG(30)
C
       WRITE(2,999)
  999  FORMAT(/,' EIGENVALUES',/)
       WRITE(2,998) (EIG(I),I=1,N)
  998  FORMAT(10F10.4)
       WRITE(2,997)
  997  FORMAT(/,' EIGENVECTORS',/)
       DO 10 I=1,N
	 WRITE(2,998) (C(I,J),J=1,N)
  10   CONTINUE
       WRITE(2,996)
  996  FORMAT(/,' BOND-ORDER MATRIX',/)
       DO 20 I=1,N
	 WRITE(2,998) (P(I,J),J=1,N)
  20   CONTINUE
       RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE ADBETA(AAL)
       COMMON /BL1/BETA(30,30)
C
       BETA(1,2)=BETA(1,2)*COS(AAL*0.01745327)
       BETA(2,1)=BETA(1,2)
       RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE ADGA(N,AAL)
       COMMON /BL2/GAMMA(30,30)
     &	      /BL14/ADGAN(30)
C
       DO 50 I=1,N
	 K=I+1
	 DO 50 J=K,N
	   IF(((ADGAN(I).LT.0.0).AND.(ADGAN(J).GT.0.0)).OR.
     &	     ((ADGAN(I).GT.0.0).AND.(ADGAN(J).LT.0.0))) GOTO 20
	   GOTO 50
  20	   GAMMA(I,J)=SQRT(COS(AAL*0.01745327))*GAMMA(I,J)
	   GAMMA(J,I)=GAMMA(I,J)
  50   CONTINUE
       RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE MGA(N)
       COMMON /BL2/GAMMA(30,30)
     &	      /BL11/AI(30),E(30),NZ(30)
C
       DO 50 I=1,N
	 GAMMA(I,I)=AI(I)-E(I)
	 K=I+1
	 DO 50 J=K,N
	   GAMMA(I,J)=1./((GAMMA(I,J)/14.41)
     &	     +(2./(AI(I)-E(I)+AI(J)-E(J))))
	   GAMMA(J,I)=GAMMA(I,J)
  50   CONTINUE
       RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE JACOBI(N,RHO)
       COMMON /BL3/A(30,30)
     &	      /BL4/S(30,30)
C
       DO 205 I=1,N
	 DO 204 J=1,I
	   IF(I.EQ.J)GOTO 203
	   S(J,I)=0.0
	   S(I,J)=0.0
	   GOTO 204
  203	   S(I,J)=1.0
  204	 CONTINUE
  205  CONTINUE
       T=0.0
       DO 30 I=2,N
	 K=I-1
	 DO 30 J=1,K
	 T=T+2.0*A(I,J)**2
   30  CONTINUE
       BN1=SQRT(T)
       BN2=(RHO/N)*BN1
       THR=BN1
       IND=0
  601  THR=THR/N
  501  DO 40 IQ=2,N
	 K=IQ-1
	 DO 401 IP=1,K
	   IF(ABS(A(IP,IQ)).LT.THR)GOTO 401
	   IND=1
	   V1=A(IP,IP)
	   V2=A(IP,IQ)
	   V3=A(IQ,IQ)
	   UM=0.5*(V1-V3)
	   IF(UM.NE.0.0)GOTO 301
	   GA=-1.0
	   GOTO 6
  301	   IF(UM) 2,3,4
   2	   UM1=-1.0
	   GOTO 5
   3	   UM1=0.0
	   GOTO 5
   4	   UM1=1.0
   5	   GA=(-UM1)*V2/SQRT(V2**2+UM**2)
   6	   ST=GA/SQRT(2.0*(1.0+SQRT(1.0-GA**2)))
	   CT=SQRT(1.0-ST**2)
	   DO 50 I=1,N
	     T=A(I,IP)*CT-A(I,IQ)*ST
	     A(I,IQ)=A(I,IP)*ST+A(I,IQ)*CT
	     A(I,IP)=T
	     T=S(I,IP)*CT-S(I,IQ)*ST
	     S(I,IQ)=S(I,IP)*ST+S(I,IQ)*CT
	     S(I,IP)=T
   50	   CONTINUE
	   DO 60 I=1,N
	     A(IP,I)=A(I,IP)
	     A(IQ,I)=A(I,IQ)
   60	   CONTINUE
	   A(IP,IP)=V1*CT**2+V3*ST**2-2.0*V2*ST*CT
	   A(IQ,IQ)=V1*ST**2+V3*CT**2+2.0*V2*ST*CT
	   A(IQ,IP)=(V1-V3)*ST*CT+V2*(CT**2-ST**2)
	   A(IP,IQ)=A(IQ,IP)
  401	 CONTINUE
   40  CONTINUE
       IF(IND.NE.1)GOTO 402
       IND=0
       GOTO 501
  402  IF(THR.GT.BN2)GOTO 601
       RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE EIGN(N)
       COMMON /BL3/A(30,30)
     &	      /BL4/S(30,30)
     &	      /BL13/EIG(30)
C
       RHO=1E-6
       CALL JACOBI(N,RHO)
       CALL RA(N)
       WRITE(6,999) (EIG(I),I=1,N)
  999  FORMAT(6F10.4)
       DO 20 I=1,N
	 DO 20 J=1,N
	   A(I,J)=S(I,J)
  20   CONTINUE
       RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE RA(N)
       COMMON /BL3/C(30,30)
     &	      /BL4/S(30,30)
     &	      /BL13/E(30)
C
       DO 10 J=1,N
	 E(J)=C(J,J)
   10  CONTINUE
       K1=N-1
       DO 3 J=1,K1
	 EM=E(J)
	 K2=J+1
	 DO 2 L=K2,N
	   IF(E(L).GE.EM) GOTO 2
	   EM=E(L)
	   MA=L
	   E(MA)=E(J)
	   E(J)=EM
	   DO 1 I=1,N
	     C(I,I)=S(I,MA)
	     S(I,MA)=S(I,J)
	     S(I,J)=C(I,I)
   1	   CONTINUE
   2	 CONTINUE
   3   CONTINUE
       K3=N-1
       DO 5 I=1,K3
	 K4=I+1
	 DO 4 J=K4,N
	   P=S(I,J)
	   S(I,J)=S(J,I)
	   S(J,I)=P
   4	 CONTINUE
   5   CONTINUE
       RETURN
       END
C
C***********************************************************************
C
       FUNCTION PATAN(A,B)
       IF(ABS(A).GE.0.000001) GOTO 10
       PATAN=0.0
       GOTO 100
   10  IF(ABS(B).GE.0.000001) GOTO 20
       C=1.570795
       GOTO 40
   20  C=ATAN(ABS(A/B))
   40  IF(B.GE.0.0) GOTO 50
       IF(A.LE.0.0) GOTO 45
       C=3.14159-C
   45  C=3.14159+C
   50  IF(A.GE.0.0) GOTO 60
       C=6.28318-C
   60  PATAN=C*57.2988
  100  RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE HEAD
       WRITE(2,999)
 999   FORMAT(//,' TRANSITION',8X,'SINGLET',3X,'TRIPLET',3X,
     &	 'TRANSITION DIPOLE',6X,'ALPHA',6X,'BETA',6X,'OSC STRENGTH'
     &	 ,6X,'ABSORPTION',//)
       RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE SPEC(ISW,I,J,S,T,Q,A,B,F)
       SP=1240./S
       IF(ISW.EQ.1) GOTO 20
       WRITE(2,999) I,J,S,T,Q,A,B,F,SP
 999   FORMAT(3X,I2,'-',I2,9X,F8.4,3X,F8.4,7X,F8.4,10X,F6.2,4X,F6.2,
     &	 6X,F8.4,11X,F8.4)
       GOTO 100
  20   WRITE(2,998) J,S,T,Q,A,B,F,SP
 998   FORMAT(4X,I2,11X,F8.4,3X,F8.4,7X,F8.4,10X,F6.2,4X,
     &	 F6.2,6X,F8.4,11X,F8.4)
 100   RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE SGTP(N,NF,NPM,NCI,NU,NL,IST,JST,ISE,JSE)
       COMMON /BL1/BETA(30,30)
     &	      /BL2/GAMMA(30,30)
     &	      /BL3/C(30,30)
     &	      /BL4/SING(30,30)
     &	      /BL5/TRIP(30,30)
     &	      /BL6/PC(30,30)
     &	      /BL12/CX(30),CY(30),CZ(30)
     &	      /BL13/EIG(30)
     &	      /BL15/QX(30),QY(30),QZ(30)
     &	      /BL16/EC1(30),EC2(30),EC3(30)
C
       DIMENSION ES(30),ET(30)
       DO 5 I=1,N
	 DO 5 J=1,N
	   C(I,J)=PC(I,J)
   5   CONTINUE
       NFP=NF+1
       NG=(NFP-NL)*(NU-NF)
       WRITE(2,999)
 999   FORMAT(//,' TRANSITIONS BEFORE CI')
       CALL HEAD
       M=0
       DO 100 I=NL,NF
	 DO 100 J=NFP,NU
	   M=M+1
	   MA=0
	   DO 80 K=NL,NF
	     DO 80 L=NFP,NU
	       MA=MA+1
	       IF(MA.GE.M)GOTO 10
	       GOTO 70
  10	       IF((NCI.EQ.0).AND.(MA.NE.M)) GOTO 15
	       GOTO 20
  15	       GOTO 70
  20	       A=0.0
	       B=0.0
	       DO 30 IP=1,N
		 Q=C(I,IP)
		 C1=0.0
		 F=0.0
		 DO 25 IR=1,N
		   X=C(L,IR)*GAMMA(IP,IR)
		   C1=C1+X*C(J,IR)
		   F=F+X*C(K,IR)
  25		 CONTINUE
		 A=A+C1*Q*C(K,IP)
		 B=B+F*Q*C(J,IP)
  30	       CONTINUE
	       SING(M,MA)=-A+2*B
	       SING(MA,M)=SING(M,MA)
	       TRIP(M,MA)=-A
	       TRIP(MA,M)=TRIP(M,MA)
	       IF(MA.NE.M) GOTO 70
	       A=EIG(J)-EIG(I)
	       SING(M,M)=SING(M,M)+A
	       TRIP(M,M)=TRIP(M,M)+A
	       IF(NPM.NE.0) GOTO 64
	       Q=0.0
	       GOTO 66
  64	       Q=0.0
	       DO 35 IP=1,N
		 Q=Q+C(I,IP)*C(J,IP)*CX(IP)
  35	       CONTINUE
	       QX(M)=Q
  66	       A=0.0
	       B=0.0
	       DO 40 IP=1,N
		 X=C(I,IP)*C(J,IP)
		 A=A+X*CY(IP)
		 B=B+X*CZ(IP)
  40	       CONTINUE
	       QY(M)=A
	       QZ(M)=B
	       B=A*A+B*B
	       Q=2*(Q*Q+B)
	       A=PATAN(QY(M),QZ(M))
	       IF(NPM.NE.0) GOTO 54
	       B=0.0
	       GOTO 56
  54	       SB=SQRT(B)
	       B=PATAN(QX(M),SB)
  56	       F=0.0875161*Q*SING(M,M)
	       I1=I
	       J1=J
	       CALL SPEC(2,I1,J1,SING(M,M),TRIP(M,M),Q,A,B,F)
	       EC1(M)=SING(M,M)
	       EC2(M)=I
	       EC3(M)=J
	       IF(M.GE.2) GOTO 50
	       X1=SING(M,M)
	       IST=I
	       JST=J
	       GOTO 52
  50	       IF(X1.LE.SING(M,M)) GOTO 52
	       X1=SING(M,M)
	       IST=I
	       JST=J
  52	       CONTINUE
  70	       CONTINUE
  80	   CONTINUE
 100   CONTINUE
       CALL REARRE(NG)
       ISE=EC2(2)
       JSE=EC3(2)
       IF(NCI.EQ.0) GOTO 200
       DO 102 I=1,NG
	 DO 102 J=1,NG
	   C(I,J)=SING(I,J)
 102   CONTINUE
       CALL EIGN(NG)
       DO 104 I=1,NG
	 ES(I)=EIG(I)
	 DO 104 J=1,NG
	   TEMP=C(I,J)
	   C(I,J)=TRIP(I,J)
	   TRIP(I,J)=TEMP
 104   CONTINUE
       CALL EIGN(NG)
       DO 106 I=1,NG
	 ET(I)=EIG(I)
	 DO 106 J=1,NG
	   SING(I,J)=TRIP(I,J)
	   TRIP(I,J)=C(I,J)
 106   CONTINUE
       WRITE(2,998)
 998   FORMAT(//,' TRANSITIONS AFTER CI')
       CALL HEAD
       DO 150 J=1,NG
	 IF(NPM.NE.0) GOTO 140
	 A=0.0
	 GOTO 145
 140	 A=0.0
	 DO 115 IP=1,NG
	   A=A+SING(J,IP)*QX(IP)
 115	 CONTINUE
 145	 B=0.0
	 C1=0.0
	 DO 120 IP=1,NG
	   B=B+SING(J,IP)*QY(IP)
	   C1=C1+SING(J,IP)*QZ(IP)
 120	 CONTINUE
	 F=B*B+C1*C1
	 Q=2*(A*A+F)
	 B=PATAN(B,C1)
	 IF(NPM.NE.0) GOTO 130
	 A=0.0
	 GOTO 135
 130	 SF=SQRT(F)
	 A=PATAN(A,SF)
 135	 F=0.0875161*Q*ES(J)
	 J2=J
	 CALL SPEC(1,I,J2,ES(J2),ET(J2),Q,B,A,F)
 150   CONTINUE
       WRITE(2,997)
 997   FORMAT(/,' SINGLET CONFIGURATION VECTORS',/)
       DO 160 I=1,NG
	 WRITE(2,996) (SING(I,J),J=1,NG)
 160   CONTINUE
 996   FORMAT(10F10.4)
       WRITE(2,995)
 995   FORMAT(/,' TRIPLET CONFIGURATION VECTORS',/)
       DO 180 I=1,NG
	 WRITE(2,996) (TRIP(I,J),J=1,NG)
 180   CONTINUE
 200   RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE REARRE(N)
       COMMON /BL16/EC1(30),EC2(30),EC3(30)
C
       L=N-1
       DO 20 I=1,L
	 EM=EC1(I)
	 K=I+1
	 DO 20 J=K,N
	   IF(EC1(J).GE.EM) GOTO 20
	   EM=EC1(J)
	   MA=J
	   EC1(MA)=EC1(I)
	   EC1(I)=EM
	   D=EC2(MA)
	   EC2(MA)=EC2(I)
	   EC2(I)=D
	   D=EC3(MA)
	   EC3(MA)=EC3(I)
	   EC3(I)=D
   20  CONTINUE
       RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE DIPOLE(N,IS)
       COMMON /BL11/AI(30),E(30),NZ(30)
     &	      /BL12/CX(30),CY(30),CZ(30)
     &	      /BL14/Q(30)
     &	      /BL16/EC1(30),EC2(30),EC3(30)
C
       A=0.0
       B=0.0
       C=0.0
       DO 10 I=1,N
	 IF(IS.EQ.0) D=NZ(I)-Q(I)
	 IF(IS.EQ.1) D=NZ(I)-EC2(I)
	 IF(IS.EQ.2) D=NZ(I)-EC3(I)
	 A=A+CX(I)*D
	 B=B+CY(I)*D
	 C=C+CZ(I)*D
  10   CONTINUE
       A=A*4.8
       B=B*4.8
       C=C*4.8
       D=B*B+C*C
       IST=IS-1
       IF(IST) 20,25,30
  20   WRITE(2,999)
 999   FORMAT(//,' PI-CONTRIBUTION TO DIPOLE MOMENT')
       GO TO 40
  25   WRITE(2,998)
 998   FORMAT(//,' FIRST EXCITED STATE DIPOLE MOMENT')
       GOTO 40
  30   WRITE(2,997)
 997   FORMAT(//,' SECOND EXCITED STATE DIPOLE MOMENT')
  40   WRITE(2,996)A
 996   FORMAT(/,5X,' X-MOMENT=',F10.4)
       WRITE(2,995)B
 995   FORMAT(/,5X,' Y-MOMENT=',F10.4)
       WRITE(2,994)C
 994   FORMAT(/,5X,' Z-MOMENT=',F10.4)
       F=D+A*A
       F=SQRT(F)
       C=PATAN(B,C)
       DS=SQRT(D)
       B=PATAN(A,DS)
       WRITE(2,993) F
 993   FORMAT(/,' TOTAL MOMENT=',F10.4)
       WRITE(2,992) C
 992   FORMAT(/,' ALPHA=',F10.4)
       WRITE(2,991) B
 991   FORMAT(/,' BETA=',F10.4)
       RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE DENSTY(IST,JST,ISE,JSE,N,NF)
       COMMON /BL6/C(30,30)
     &	      /BL16/EC1(30),EC2(30),EC3(30)
C
       WRITE(2,999)
  999  FORMAT(/,' ELECTRON DENSITY CHANGES')
       WRITE(2,998)IST,JST
  998  FORMAT(//,' ROWS USED=',I2,'-',I2,//)
       DO 20 I=1,N
	 EC1(I)=C(JST,I)*C(JST,I)-C(IST,I)*C(IST,I)
   20  CONTINUE
       WRITE(2,997) (EC1(I),I=1,N)
  997  FORMAT(10F10.4)
       WRITE(2,996)
  996  FORMAT(//,' EXCITED STATE ELECTRON DENSITY')
       WRITE(2,998) IST,JST
       DO 30 I=1,N
	 D=0.0
	 DO 25 K=1,NF
	   IF(K.EQ.IST) GOTO 25
	   D=D+C(K,I)*C(K,I)
  25	 CONTINUE
	 EC2(I)=2*D+C(IST,I)*C(IST,I)+C(JST,I)*C(JST,I)
  30   CONTINUE
       WRITE(2,997) (EC2(I),I=1,N)
       WRITE(2,994)
  994  FORMAT(//,' SECOND EXCITED STATE ELECTRON DENSITY')
       WRITE(2,998) ISE,JSE
       DO 50 I=1,N
	 D=0.0
	 DO 45 K=1,NF
	   IF (K.EQ.ISE) GOTO 45
	   D=D+C(K,I)*C(K,I)
   45	 CONTINUE
	 EC3(I)=2*D+C(ISE,I)*C(ISE,I)+C(JSE,I)*C(JSE,I)
   50  CONTINUE
       WRITE(2,997) (EC3(I),I=1,N)
       RETURN
       END
C
C***********************************************************************
C
       SUBROUTINE PRESVE(N)
       COMMON /BL3/C(30,30)
     &	      /BL5/Q(30,30)
     &	      /BL6/PC(30,30)
     &	      /BL14/ADGAN(30)
C
       DO 10 I=1,N
	 ADGAN(I)=Q(I,I)
	 DO 10 J=1,N
	   PC(I,J)=C(I,J)
   10  CONTINUE
       RETURN
       END
C

C***** END OF PROGRAM LISTING ******************************************
